using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PI.ZB.N1200.ELearning.WinForms.SchoolYear
{
    public partial class FCloseSchoolYear : PI.FM.N000.Base.WinForms.Controls.Form
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(this.Environment);
                }
                return _blZSBELearning;
            }
        }

        public FCloseSchoolYear()
        {
            InitializeComponent();
        }

        public void Initialize(BL.BO.SchoolYear SchoolYear, Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment Environment)
        {
            base.Initialize(ParentPlugIn, Environment);

            _gLabelMessage.Text = String.Format(BL.Dictionary.Text.SchoolYear.Confirm_Close.Value, SchoolYear.Name);
        }

        private void OK_Click(object sender, EventArgs e)
        {
            if (((PI.FM.N001.Account.BL.BO.User)Environment.User).Password == _gTextBoxPassword.Text)
            {
                DialogResult = DialogResult.OK;
                Close();
            }
            else
            {
                DialogResult = DialogResult.None;
                DispalyMessage(Gemini.Dictionary.Text.IncorrectPassword.Value);
            }
        }
    }
}